unit IWMain;

interface

{$IFNDEF CLR}
  {$DENYPACKAGEUNIT ON}
{$ENDIF}

uses
  {$IFDEF CLR}
  System.Resources, System.Reflection, System.Drawing, SWSystem,
  {$ENDIF}
  {$IFDEF Linux}QActnList,{$ELSE}ActnList,{$ENDIF}
  {$IFDEF Linux}QControls,{$ELSE}Controls,{$ENDIF}
  {$IFDEF Linux}QComCtrls,{$ELSE}ComCtrls,{$ENDIF}
  {$IFDEF Linux}QForms,{$ELSE}Forms,{$ENDIF}
  {$IFDEF Linux}QGraphics,{$ELSE}Windows, Graphics,{$ENDIF}
  {$IFDEF Linux}QStdCtrls,{$ELSE}StdCtrls,{$ENDIF}
  {$IFDEF Linux}QExtCtrls,{$ELSE}ExtCtrls,{$ENDIF}
  {$IFDEF Linux}QDialogs,{$ELSE}Dialogs,{$ENDIF}
  {$IFDEF Linux}QClipbrd,{$ELSE}Clipbrd,{$ENDIF}
  {$IFDEF Linux}Types,{$ELSE}Messages,{$ENDIF}

  Classes,
  IWHTTPServer, IWStandAloneServer, Menus, ShellApi,
  SysUtils, SyncObjs;
{$IFDEF Linux}
(*$HPPEMIT '#pragma link "IWMain.o"'*)
{$ELSE}
(*$HPPEMIT '#pragma link "IWMain.obj"'*)
{$ENDIF}

type
  TFormIWMain = class(TForm)
  private
    tbarMain: TToolBar;
    butnExecute: TToolButton;
    butnCopyLink: TToolButton;
    butnResetSession: TToolButton;
    ToolButton4: TToolButton;
    butnDebugLog: TToolButton;
    butnUseSSL: TToolButton;
    ToolButton7: TToolButton;
    butnHelp: TToolButton;
    pctrlMain: TPageControl;
    tabsServer: TTabSheet;
    lablTextDevice: TLabel;
    imgDevice: TImage;
    lablTextSpeed: TLabel;
    imgSpeed: TImage;
    lablTextSent: TLabel;
    lablTextSession: TLabel;
    lablSessions: TLabel;
    lablData: TLabel;
    lablTextParams: TLabel;
    cboxSimulator: TComboBox;
    cboxSpeed: TComboBox;
    editParams: TEdit;
    tabsLog: TTabSheet;
    memoLog: TMemo;
    menuMain: TMainMenu;
    File1: TMenuItem;
    Run1: TMenuItem;
    N1: TMenuItem;
    Shutdown1: TMenuItem;
    Settings1: TMenuItem;
    View1: TMenuItem;
    SmallIcons1: TMenuItem;
    LargeIcons1: TMenuItem;
    N5: TMenuItem;
    Debug1: TMenuItem;
    UseSSL1: TMenuItem;
    N4: TMenuItem;
    RunMinimized1: TMenuItem;
    RuninTrayicon1: TMenuItem;
    N3: TMenuItem;
    Browser1: TMenuItem;
    Default1: TMenuItem;
    N7: TMenuItem;
    InternetExplorer1: TMenuItem;
    FireFox1: TMenuItem;
    Opera1: TMenuItem;
    Mozilla1: TMenuItem;
    Netscape1: TMenuItem;
    ools1: TMenuItem;
    CopyStartURL1: TMenuItem;
    N2: TMenuItem;
    ResetSessions1: TMenuItem;
    ResetSentdata1: TMenuItem;
    ilstLarge: TImageList;
    alstMain: TActionList;
    actnExecute: TAction;
    actnCopyLink: TAction;
    actnResetSessions: TAction;
    actnShutdown: TAction;
    actnResetBytes: TAction;
    actnDebug: TAction;
    actnRunMinimized: TAction;
    actnRunTray: TAction;
    actnBrowserDefault: TAction;
    actnUseSSL: TAction;
    actnSmallIcons: TAction;
    actnLargeIcons: TAction;
    actnIE: TAction;
    actnFireFox: TAction;
    actnOpera: TAction;
    actnMozilla: TAction;
    actnNetscape: TAction;
    ilstSmall: TImageList;
    popupMain: TPopupMenu;
    PopupTitle: TMenuItem;
    N6: TMenuItem;
    Restore1: TMenuItem;
    Shutdown2: TMenuItem;
    FStandaloneServer: TIWStandAloneServer;
    procedure InitForm;

    procedure actnSmallIconsExecute(Sender: TObject);
    procedure actnLargeIconsExecute(Sender: TObject);
    procedure cboxSimulatorChange(Sender: TObject);
    procedure cboxSpeedChange(Sender: TObject);
    procedure alstMainUpdate(Action: TBasicAction;
      var Handled: Boolean);
    procedure actnBrowserDefaultExecute(Sender: TObject);
    procedure actnShutdownExecute(Sender: TObject);
    procedure actnDebugExecute(Sender: TObject);
    procedure actnRunMinimizedExecute(Sender: TObject);
    procedure actnCopyLinkExecute(Sender: TObject);
    procedure actnResetSessionsExecute(Sender: TObject);
    procedure actnResetBytesExecute(Sender: TObject);
    procedure actnUseSSLExecute(Sender: TObject);
    procedure menuAboutClick(Sender: TObject);

    procedure Restore1Click(Sender: TObject);
    procedure actnIEExecute(Sender: TObject);
    procedure actnFireFoxExecute(Sender: TObject);
    procedure actnOperaExecute(Sender: TObject);
    procedure actnMozillaExecute(Sender: TObject);
    procedure actnNetscapeExecute(Sender: TObject);
    procedure MinimizeApp(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure OnDebugLog(ASender: TObject; ALog: String);
    procedure OnDebugLogBytes(ASender: Tobject; ABytes: Integer);
    procedure OnUpdateTotalBytes(ASender: TObject; const ABytes: Integer);
    procedure SetConnectionSpeed(AValue: Integer);
    procedure SetTotalBytes;
    procedure UpdateBrowserSelectionAction;
    procedure DoOnCustomSpeedChange(Sender: TObject);
    procedure actnExecuteOnExecute(Sender: TObject);
    procedure actnRunTrayExecute(Sender: TObject);
    procedure DoCreateSession(Sender: TObject);
    procedure DoDestroySession(Sender: TObject);
    procedure editParamsChange(Sender: TObject);
    procedure AboutOnClick(Sender: TObject);
  protected
    FCustomSpeedEdit : TEdit;
    FCustomSpeedLabel : TLabel;
    FBitsPerSec : integer;
    FSessionCount: Integer;
    procedure OnFirstShow(Sender: TObject);
  public
    FIconData : TNotifyIconData;
    function MessageHook(var Msg : TMessage) : Boolean;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Log(const AMsg: string);
    procedure LogBytes(const ABytes: Integer);
    procedure CreateTrayIcon;
    procedure FreeTrayIcon;

  end;

var
  FormIWMain: TformIWMain;

implementation

{$I IWCompilerDefines.inc}
{$IFDEF CLR}
  {$R IWMainToolbarImages.resx}
  {$R IWMainIcons.resx}
  {$R IWMainAboutSplash.resx}
{$ELSE}
  {$R IWMain.res}
{$ENDIF}

uses
  {$IFDEF Linux}QImgList,{$ELSE}ImgList,{$ENDIF}
  {$IFDEF Linux}
    IWJPeg,
  {$ELSE}
    {$IFDEF CLR}
    IWNETJpeg,
    {$ELSE}
    JPeg,
    {$ENDIF}
  {$ENDIF}
  {$IFDEF Linux}Libc, Qt,{$ELSE}Registry,{$ENDIF}
  {$IFNDEF CLR}
  {$IFDEF VCL7ORABOVE}XPMan,{$ENDIF}
  {$ENDIF}
  IWApplication, IWGlobal, IWServerControllerBase, IWResourceStrings,
  IWUtils,
  InSync, INIFiles;

//Type
//Todo:  TIWMainUpdateSessions = class(TIdNotifyMethod)
//  public
//    class procedure UpdateSessions;
//  end;

const
  cDeviceToResourceName : array[0..5] of string =
          (
            'DEV_MODEM',
            'DEV_MODEM',
            'DEV_MODEM',
            'DEV_MODEM',
            'DEV_CABLE',
            'DEV_NETWORK'
          );
  cSimulatorIdToResourceName: array[0..2] of string =
          (
            'PDA',
            'PHONE',
            'PHONE'
          );

// This is here to avoid having to reference Menus/QMenus when ShortCut is called as it conflicts
// in the with statements with the ShortCut property
function MakeShortCut(AKey: Word; AShift: TShiftState): TShortCut;
begin
  Result := ShortCut(AKey, AShift);
end;

{ TFormIWMain }
constructor TFormIWMain.Create(AOwner: TComponent);
begin
  CreateNew(AOwner);
  InitForm;
end;


destructor TFormIWMain.Destroy;
var
  LFilename: string;
  LWriteFile: Boolean;
begin
  if Assigned(FStandaloneServer) then begin
    LFilename := ChangeFileExt(PAramStr(0), '.iwb');
    {$IFDEF CLR}
    LWriteFile := True;
    {$ELSE}
    if FileExists(LFilename) then begin
      LWriteFile := (GetfileAttributes(PChar(LFilename)) and faReadOnly) = 0;
    end else begin
      LWriteFile := True;
    end;
    {$ENDIF}
    if LWriteFile then begin
      with TINIFile.Create(LFilename) do try
        try
          WriteString('Main', 'Parameters', FStandAloneServer.Params);
          WriteBool('Main', 'SSL', FStandAloneServer.RunSSL);
          WriteBool('Main', 'DebugInfo', FStandAloneServer.DebugLog);
          WriteBool('Main', 'HTML32', FStandAloneServer.HTML32);
          WriteBool('Main', 'WML', FSTandaLoneServer.WML);
          WriteBool('Main', 'XHTMLMP', FSTandaLoneServer.XHTMLMP);
          WriteInteger('Main', 'RunIn', Integer(FStandAloneServer.RunIn));
          WriteInteger('HTTP', 'SpeedLimit', GHTTPServer.BitsPerSec);
          WriteBool('Main', 'RunMinimized', actnRunMinimized.Checked);
          WriteBool('Main', 'RunInTray', actnRunTray.Checked);
          UpdateFile;
        except
          // eat exceptions....this is not vital...
        end;
      finally Free; end;
    end;
  end;
  if actnRunTray.Checked then
    FreeTrayIcon;

  FreeAndNil(ilstLarge);
  FreeAndNil(ilstSmall);

  inherited Destroy;
end;

procedure TFormIWMain.actnBrowserDefaultExecute(Sender: TObject);
begin
  FStandaloneServer.RunIn := wbDefault;
  UpdateBrowserSelectionAction;
end;

procedure TFormIWMain.actnCopyLinkExecute(Sender: TObject);
begin
  FStandaloneServer.CopyStartURLToClipboard;
end;

procedure TFormIWMain.actnDebugExecute(Sender: TObject);
begin
  FStandaloneServer.DebugLog := not FStandaloneServer.DebugLog;
end;

procedure TFormIWMain.actnFireFoxExecute(Sender: TObject);
begin
  FStandaloneServer.RunIn := wbFirefox;
  UpdateBrowserSelectionAction;
end;

procedure TFormIWMain.actnIEExecute(Sender: TObject);
begin
  FStandaloneServer.RunIn := wbIE;
  UpdateBrowserSelectionAction;
end;

procedure TFormIWMain.actnLargeIconsExecute(Sender: TObject);
begin
  tbarMain.Images := ilstLarge;
  tbarMain.ButtonWidth := 24;
  tbarMain.ButtonHeight := 24;
  ToolButton4.Width := 8;
  ToolButton7.Width := 8;
end;

procedure TFormIWMain.actnMozillaExecute(Sender: TObject);
begin
  FStandaloneServer.RunIn := wbMozilla;
  UpdateBrowserSelectionAction;
end;

procedure TFormIWMain.actnNetscapeExecute(Sender: TObject);
begin
  FStandaloneServer.RunIn := wbNS6;
  UpdateBrowserSelectionAction;
end;

procedure TFormIWMain.actnOperaExecute(Sender: TObject);
begin
  FStandaloneServer.RunIn := wbOpera;
  UpdateBrowserSelectionAction;
end;

procedure TFormIWMain.actnResetBytesExecute(Sender: TObject);
begin
  SetTotalBytes;
end;

procedure TFormIWMain.actnResetSessionsExecute(Sender: TObject);
begin
  FStandaloneServer.ClearSessions;
  lablSessions.Caption := '0';
  SetTotalBytes;
end;

procedure TFormIWMain.actnRunMinimizedExecute(Sender: TObject);
begin
  actnRunMinimized.Checked := not actnRunMinimized.Checked;
  if actnRunMinimized.Checked then
  begin
    WindowState := wsMinimized;
  end;
end;

procedure TFormIWMain.actnShutdownExecute(Sender: TObject);
begin
  Close;
end;

procedure TFormIWMain.actnSmallIconsExecute(Sender: TObject);
begin
  tbarMain.Images := ilstSmall;
  tbarMain.ButtonWidth := 16;
  tbarMain.ButtonHeight := 16;
  ToolButton4.Width := 4;
  ToolButton7.Width := 4;
end;

procedure TFormIWMain.actnUseSSLExecute(Sender: TObject);
begin
  FStandaloneServer.RunSSL := not FStandaloneServer.RunSSL;
end;

procedure TFormIWMain.alstMainUpdate(Action: TBasicAction;
  var Handled: Boolean);
begin
  actnDebug.Checked := FStandaloneServer.DebugLog;
  actnUseSSL.Checked := FStandaloneServer.RunSSL;
  actnLargeIcons.Checked := tbarMain.Images = ilstLarge;
  actnSmallIcons.Checked := tbarMain.Images = ilstSmall;
  Handled := True;
end;

procedure TFormIWMain.cboxSimulatorChange(Sender: TObject);
  procedure ChangeDeviceImage;
  var
    ResourceStream: TResourceStream;
  begin
    if cboxSimulator.ItemIndex in [0] then
    begin
      imgDevice.Visible := False;
    end
    else
    begin
      LockWindowUpdate(Self.Handle);
      try
        imgDevice.Visible := True;
        {$IFNDEF CLR}
        ResourceStream := TResourceStream.Create(HInstance, cSimulatorIdToResourceName[cboxSimulator.ItemIndex - 1], RT_RCDATA);
        {$ENDIF}
        try
          imgDevice.Picture.Bitmap := TBitmap.Create;
          imgDevice.Picture.Bitmap.LoadFromStream(ResourceStream);
        finally
          FreeAndNil(ResourceStream);
        end;
      finally
        LockWindowUpdate(0);
      end;
    end;
  end;
begin
  FStandaloneServer.HTML32 := cboxSimulator.ItemIndex = 1;
  FStandaloneServer.WML := cboxSimulator.ItemIndex = 2;
  FStandaloneServer.XHTMLMP := cboxSimulator.ItemIndex = 3;
  ChangeDeviceImage;
end;

procedure TFormIWMain.cboxSpeedChange(Sender: TObject);
  procedure ChangeSpeedImage;
  var
    ResourceStream: TResourceStream;
  begin
    if cboxSpeed.ItemIndex in [0, 7] then
    begin
      imgSpeed.Visible := False;
    end
    else
    begin
      LockWindowUpdate(Self.Handle);
      try
        imgSpeed.Visible := True;
        {$IFNDEF CLR}
        ResourceStream := TResourceStream.Create(HInstance, cDeviceToResourceName[cboxSpeed.ItemIndex - 1], RT_RCDATA);
        {$ENDIF}
        try
          imgSpeed.Picture.Bitmap := TBitmap.Create;
          imgSpeed.Picture.Bitmap.LoadFromStream(ResourceStream);
        finally
          FreeAndNil(ResourceStream);
        end;
      finally
        LockWindowUpdate(0);
      end;
    end;
  end;
begin
  FCustomSpeedLabel.Visible := cboxSpeed.ItemIndex = 7;
  FCustomSpeedEdit.Visible := cboxSpeed.ItemIndex = 7;

  case cboxSpeed.ItemIndex of
    0 : begin
          FBitsPerSec := 0;
        end;
    1 : begin
          FBitsPerSec := 28800;
        end;
    2 : begin
          FBitsPerSec := 33600;
        end;
    3 : begin
          FBitsPerSec := 64000;
        end;
    4 : begin
          FBitsPerSec := 128000;
        end;
    5 : begin
          FBitsPerSec := 384000;
        end;
    6 : begin
          FBitsPerSec := 10000000;
        end;
    7 : begin
          FBitsPerSec := StrToIntDef(FCustomSpeedEdit.Text, 0);
        end;
  end;
  ChangeSpeedImage;
  SetConnectionSpeed(FBitsPerSec);
end;



procedure TFormIWMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin

end;

procedure TFormIWMain.InitForm;

 procedure InitMenus;
  begin
    menuMain := TMainMenu.Create(Self);
    popupMain := TPopupMenu.Create(Self);
    Debug1 := TMenuItem.Create(Self);
    Default1 := TMenuItem.Create(Self);
    File1 := TMenuItem.Create(Self);
    FireFox1 := TMenuItem.Create(Self);
    LargeIcons1 := TMenuItem.Create(Self);
    InternetExplorer1 := TMenuItem.Create(Self);
    Mozilla1 := TMenuItem.Create(Self);
    N1 := TMenuItem.Create(Self);
    N2 := TMenuItem.Create(Self);
    N3 := TMenuItem.Create(Self);
    N4 := TMenuItem.Create(Self);
    N5 := TMenuItem.Create(Self);
    N6 := TMenuItem.Create(Self);
    N7 := TMenuItem.Create(Self);
    Netscape1 := TMenuItem.Create(Self);
    ools1 := TMenuItem.Create(Self);
    Opera1 := TMenuItem.Create(Self);
    PopupTitle := TMenuItem.Create(Self);
    ResetSentdata1 := TMenuItem.Create(Self);
    ResetSessions1 := TMenuItem.Create(Self);
    Restore1 := TMenuItem.Create(Self);
    Run1 := TMenuItem.Create(Self);
    RuninTrayicon1 := TMenuItem.Create(Self);
    RunMinimized1 := TMenuItem.Create(Self);
    Settings1 := TMenuItem.Create(Self);
    Shutdown1 := TMenuItem.Create(Self);
    Shutdown2 := TMenuItem.Create(Self);
    SmallIcons1 := TMenuItem.Create(Self);
    UseSSL1 := TMenuItem.Create(Self);
    View1 := TMenuItem.Create(Self);
    Browser1 := TMenuItem.Create(Self);
    CopyStartURL1 := TMenuItem.Create(Self);
    // menu 26 items
    with menuMain do
    begin
      Name := 'menuMain';
      Images := ilstSmall;
    end;
    with Debug1 do
    begin
      Name := 'Debug1';
      Action := actnDebug;
    end;
    with Default1 do
    begin
      Name := 'Default1';
      Action := actnBrowserDefault;
    end;
    with File1 do
    begin
      Name := 'File1';
      Caption := 'File';
    end;
    with FireFox1 do
    begin
      Name := 'FireFox1';
      Action := actnFireFox;
    end;
    with LargeIcons1 do
    begin
      Name := 'LargeIcons1';
      Action := actnLargeIcons;
    end;
    with InternetExplorer1 do
    begin
      Name := 'InternetExplorer1';
      Action := actnIE;
    end;
    with Mozilla1 do
    begin
      Name := 'Mozilla1';
      Action := actnMozilla;
    end;
    with N1 do
    begin
      Name := 'N1';
      Caption := '-';
    end;
    with N2 do
    begin
      Name := 'N2';
      Caption := '-';
    end;
    with N3 do
    begin
      Name := 'N3';
      Caption := '-';
    end;
    with N4 do
    begin
      Name := 'N4';
      Caption := '-';
    end;
    with N5 do
    begin
      Name := 'N5';
      Caption := '-';
    end;
    with N6 do
    begin
      Name := 'N6';
      Caption := '-';
    end;
    with N7 do
    begin
      Name := 'N7';
      Caption := '-';
    end;
    with Netscape1 do
    begin
      Name := 'Netscape1';
      Action := actnNetscape;
    end;
    with ools1 do
    begin
      Name := 'ools1';
      Caption := 'Tools';
    end;
    with Opera1 do
    begin
      Name := 'Opera1';
      Action := actnOpera;
    end;
    with PopupTitle do
    begin
      Name := 'PopupTitle';
      Caption := Application.Title;
    end;
    with ResetSentdata1 do
    begin
      Name := 'ResetSentdata1';
      Action := actnResetBytes;
    end;
    with ResetSessions1 do
    begin
      Name := 'ResetSessions1';
      Action := actnResetSessions;
    end;
    with Restore1 do
    begin
      Name := 'Restore1';
      Caption := 'Restore';
      OnClick := Restore1Click;
      Default := true;
    end;
    with Run1 do
    begin
      Name := 'Run1';
      Action := actnExecute;
    end;
    with RuninTrayicon1 do
    begin
      Name := 'RuninTrayicon1';
      Action := actnRunTray;
    end;
    with RunMinimized1 do
    begin
      Name := 'RunMinimized1';
      Action := actnRunMinimized;
    end;
    with Settings1 do
    begin
      Name := 'Settings1';
      Caption := 'Settings';
    end;
    with Shutdown1 do
    begin
      Name := 'Shutdown1';
      Action := actnShutdown;
    end;
    with Shutdown2 do
    begin
      Name := 'Shutdown2';
      Action := actnShutdown;
    end;
    with SmallIcons1 do
    begin
      Name := 'SmallIcons1';
      Action := actnSmallIcons;
    end;
    with UseSSL1 do
    begin
      Name := 'UseSSL1';
      Action := actnUseSSL;
    end;
    with View1 do
    begin
      Name := 'View1';
      Caption := 'View';
    end;
    with Browser1 do
    begin
      Name := 'Browser1';
      Caption := 'Browser';
    end;
    with CopyStartURL1 do
    begin
      Name := 'CopyStartURL1';
//      Caption := 'Copy Start URL';
      Action := actnCopyLink;
    end;
    with popupMain do
    begin
      Name := 'popupMain';
    end;
    menuMain.Items.Add([File1, Settings1, ools1]);
    File1.Add([Run1, N1, Shutdown1]);
    Settings1.Add([View1, N5, Debug1, UseSSL1, N4, RunMinimized1,
                   RuninTrayicon1, N3, Browser1]);
    View1.Add([SmallIcons1, LargeIcons1]);
    Browser1.Add([Default1, N7, InternetExplorer1, FireFox1, Opera1, Mozilla1, Netscape1]);
    ools1.Add([CopyStartURL1, N2, ResetSessions1, ResetSentdata1]);
    popupMain.Items.Add([PopupTitle, N6, Restore1, Shutdown2]);
  end;

  procedure InitImageLists;

    function GetBitmap(AName: string): TBitmap;
    var
      RStream: TResourceStream;
    begin
      {$IFNDEF CLR}
      RStream := TResourceStream.Create(HInstance, AName, RT_RCDATA);
      {$ENDIF}
      try
        Result := TBitmap.Create;
        {$IFDEF CLR}
         Result.LoadFromResourceName(AName, 'IWMainToolbarImages', Assembly.GetExecutingAssembly);
        {$ELSE}
        Result.LoadFromStream(RStream);
        {$ENDIF}
      finally
        {$IFNDEF CLR}
        FreeAndNil(RStream);
        {$ENDIF}
      end;
    end;

    function GetIcon(AName: string): TIcon;
    var
      RStream: TResourceStream;
    begin
      {$IFNDEF CLR}
      RStream := TResourceStream.Create(HInstance, AName, RT_RCDATA);
      {$ENDIF}
      try
        Result := TIcon.Create;
        {$IFDEF CLR}
        Result.LoadFromResourceName(AName, 'IWMainIcons', Assembly.GetExecutingAssembly);
        {$ELSE}
        Result.LoadFromStream(RStream);
        {$ENDIF}
      finally
        {$IFNDEF CLR}
        FreeAndNil(RStream);
        {$ENDIF}
      end;
    end;


  var
    {$IFDEF CLR}
    LRM : ResourceManager;
    {$ELSE}
    LBitmap : TBitmap;
    LIcon : TIcon;
    {$ENDIF}

  begin
    ilstLarge := TImageList.Create(Self);
    ilstSmall := TImageList.Create(Self);
    with ilstLarge do
    begin
      Name := 'ilstLarge';
      Width := 24;
      Height := 24;
    end;
    with ilstSmall do
    begin
      Name := 'ilstSmall';
      Width := 16;
      Height := 16;
    end;
    {$IFNDEF CLR}
    LIcon := GetIcon('IW_ICON');
    Self.Icon.Assign(LIcon);
    FreeAndNil(LIcon);

    LIcon := GetIcon('IW_ICON');
    Application.Icon.Assign(LIcon);
    FreeAndNil(LIcon);
    {$ENDIF}
    {$IFDEF CLR}
    try
      {0}  ilstSmall.AddMasked(GetBitmap('BTN_HTTP_SMALL'), clFuchsia);
      {1}  ilstSmall.AddMasked(GetBitmap('BTN_COPY_SMALL'), clFuchsia);
      {2}  ilstSmall.AddMasked(GetBitmap('BTN_CLEAN_SMALL'), clFuchsia);
      {3}  ilstSmall.AddMasked(GetBitmap('BTN_DEBUG_SMALL'), clFuchsia);
      {4}  ilstSmall.AddMasked(GetBitmap('BTN_HTTPS_SMALL'), clFuchsia);
      {5}  ilstSmall.AddMasked(GetBitmap('BTN_ABOUT_SMALL'), clFuchsia);
      {6}  ilstSmall.AddMasked(GetBitmap('BTN_OPERA_SMALL'), clFuchsia);
      {7}  ilstSmall.AddMasked(GetBitmap('BTN_FIREFOX_SMALL'), clFuchsia);
      {8}  ilstSmall.AddMasked(GetBitmap('BTN_IE_SMALL'), clFuchsia);
      {9}  ilstSmall.AddMasked(GetBitmap('BTN_MOZILLA_SMALL'), clFuchsia);
      {10} ilstSmall.AddMasked(GetBitmap('BTN_NETSCAPE_SMALL'), clFuchsia);
      {11} ilstSmall.AddMasked(GetBitmap('BTN_SETSPEED_SMALL'), clDkGray);
      {12} ilstSmall.AddMasked(GetBitmap('BTN_SIMULATEHTML32_SMALL'), clDkGray);
      {13} ilstSmall.AddMasked(GetBitmap('BTN_PARAMS_SMALL'), clDkGray);
      {14} ilstSmall.AddMasked(GetBitmap('BTN_SIMULATEWML_SMALL'), clDkGray);
      {15} ilstSmall.AddMasked(GetBitmap('BTN_SIMULATEXHTMLMP_SMALL'), clDkGray);

      {0}  ilstLarge.AddMasked(GetBitmap('BTN_HTTP_LARGE'), clFuchsia);
      {1}  ilstLarge.AddMasked(GetBitmap('BTN_COPY_LARGE'), clFuchsia);
      {2}  ilstLarge.AddMasked(GetBitmap('BTN_CLEAN_LARGE'), clFuchsia);
      {3}  ilstLarge.AddMasked(GetBitmap('BTN_DEBUG_LARGE'), clFuchsia);
      {4}  ilstLarge.AddMasked(GetBitmap('BTN_HTTPS_LARGE'), clFuchsia);
      {5}  ilstLarge.AddMasked(GetBitmap('BTN_ABOUT_LARGE'), clFuchsia);
      {6}  ilstLarge.AddMasked(GetBitmap('BTN_OPERA_LARGE'), clFuchsia);
      {7}  ilstLarge.AddMasked(GetBitmap('BTN_FIREFOX_LARGE'), clFuchsia);
      {8}  ilstLarge.AddMasked(GetBitmap('BTN_IE_LARGE'), clFuchsia);
      {9}  ilstLarge.AddMasked(GetBitmap('BTN_MOZILLA_LARGE'), clFuchsia);
      {10} ilstLarge.AddMasked(GetBitmap('BTN_NETSCAPE_LARGE'), clFuchsia);
      {11} ilstLarge.AddMasked(GetBitmap('BTN_SETSPEED_LARGE'), clDkGray);
      {12} ilstLarge.AddMasked(GetBitmap('BTN_SIMULATEHTML32_LARGE'), clDkGray);
      {13} ilstLarge.AddMasked(GetBitmap('BTN_PARAMS_LARGE'), clDkGray);
      {14} ilstLarge.AddMasked(GetBitmap('BTN_SIMULATEWML_LARGE'), clDkGray);
      {15} ilstLarge.AddMasked(GetBitmap('BTN_SIMULATEXHTMLMP_LARGE'), clDkGray);

      except
        raise Exception.Create(RSToolBarError);
      end
 {$ELSE}
    LBitmap := GetBitmap('Large_0');
    ilstLarge.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Large_1');
    ilstLarge.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Large_2');
    ilstLarge.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Large_3');
    ilstLarge.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Large_4');
    ilstLarge.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Large_5');
    ilstLarge.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Large_6');
    ilstLarge.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Large_7');
    ilstLarge.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Large_8');
    ilstLarge.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Large_9');
    ilstLarge.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Large_10');
    ilstLarge.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Small_0');
    ilstSmall.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Small_1');
    ilstSmall.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Small_2');
    ilstSmall.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Small_3');
    ilstSmall.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Small_4');
    ilstSmall.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Small_5');
    ilstSmall.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Small_6');
    ilstSmall.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Small_7');
    ilstSmall.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Small_8');
    ilstSmall.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Small_9');
    ilstSmall.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    LBitmap := GetBitmap('Small_10');
    ilstSmall.AddMasked(LBitmap, clFuchsia);
    FreeAndNil(LBitmap);
    {$ENDIF}
  end;

  procedure InitActionList;
  begin
    actnBrowserDefault := TAction.Create(Self);
    actnCopyLink := TAction.Create(Self);
    actnDebug := TAction.Create(Self);
    actnExecute := TAction.Create(Self);
    actnFireFox := TAction.Create(Self);
    actnIE := TAction.Create(Self);
    actnLargeIcons := TAction.Create(Self);
    actnMozilla := TAction.Create(Self);
    actnNetscape := TAction.Create(Self);
    actnOpera := TAction.Create(Self);
    actnResetBytes := TAction.Create(Self);
    actnResetSessions := TAction.Create(Self);
    actnRunMinimized := TAction.Create(Self);
    actnRunTray := TAction.Create(Self);
    actnShutdown := TAction.Create(Self);
    actnSmallIcons := TAction.Create(Self);
    actnUseSSL := TAction.Create(Self);
    alstMain := TActionList.Create(Self);
    with alstMain do
    begin
      Name := 'alstMain';
      Images := ilstLarge;
      OnUpdate := alstMainUpdate;
    end;
    with actnExecute do
    begin
      ActionList := alstMain;
      Name := 'actnExecute';
      Category := 'File';
      Caption := 'Execute';
      Hint := 'Execute';
      ImageIndex := 0;
      ShortCut := 120;
      OnExecute := actnExecuteOnExecute;
    end;
    with actnCopyLink do
    begin
      ActionList := alstMain;
      Name := 'actnCopyLink';
      Category := 'Tools';
      Caption := 'Copy Start URL';
      Hint := 'Copy Start URL';
      ImageIndex := 1;
      OnExecute := actnCopyLinkExecute;
    end;
    with actnResetSessions do
    begin
      ActionList := alstMain;
      Name := 'actnResetSessions';
      Category := 'Tools';
      Caption := 'Reset Sessions';
      Hint := 'Reset Sessions';
      ImageIndex := 2;
      OnExecute := actnResetSessionsExecute;
    end;
    with actnShutdown do
    begin
      ActionList := alstMain;
      Name := 'actnShutdown';
      Category := 'File';
      Caption := 'Shutdown';
      Hint := 'Shutdown';
      OnExecute := actnShutdownExecute;
    end;
    with actnResetBytes do
    begin
      ActionList := alstMain;
      Name := 'actnResetBytes';
      Category := 'Tools';
      Caption := 'Reset Sent data';
      Hint := 'Reset Sent Data';
      OnExecute := actnResetBytesExecute;
    end;
    with actnDebug do
    begin
      ActionList := alstMain;
      Name := 'actnDebug';
      Category := 'Settings';
      Caption := 'Debug Log';
      Hint := 'Debug Log';
      ImageIndex := 3;
      OnExecute := actnDebugExecute;
    end;
    with actnRunMinimized do
    begin
      ActionList := alstMain;
      Name := 'actnRunMinimized';
      Category := 'Settings';
      Caption := 'Run Minimized';
      Hint := 'Run Minimized';
      OnExecute := actnRunMinimizedExecute;
    end;
    with actnRunTray do
    begin
      ActionList := alstMain;
      Name := 'actnRunTray';
      Category := 'Settings';
      Caption := 'Run in Tray icon';
      Hint := 'Run in Tray icon';
      OnExecute := actnRunTrayExecute;
    end;
    with actnBrowserDefault do
    begin
      ActionList := alstMain;
      Name := 'actnBrowserDefault';
      Category := 'Browser';
      Caption := 'Default';
      Hint := 'Default Browser';
      ImageIndex := 0;
      OnExecute := actnBrowserDefaultExecute;
    end;
    with actnUseSSL do
    begin
      ActionList := alstMain;
      Name := 'actnUseSSL';
      Category := 'Tools';
      Caption := 'Use SSL';
      Hint := 'Use SSL';
      ImageIndex := 4;
      OnExecute := actnUseSSLExecute;
    end;
    with actnSmallIcons do
    begin
      ActionList := alstMain;
      Name := 'actnSmallIcons';
      Category := 'Settings';
      Caption := 'Small Icons';
      Hint := 'Small Icons';
      OnExecute := actnSmallIconsExecute;
    end;
    with actnLargeIcons do
    begin
      ActionList := alstMain;
      Name := 'actnLargeIcons';
      Category := 'Settings';
      Caption := 'Large Icons';
      Hint := 'Large Icons';
      Checked := True;
      OnExecute := actnLargeIconsExecute;
    end;
    with actnIE do
    begin
      ActionList := alstMain;
      Name := 'actnIE';
      Category := 'Browser';
      Caption := 'Internet Explorer';
      Hint := 'Internet Explorer';
      ImageIndex := 8;
      OnExecute := actnIEExecute;
    end;
    with actnFireFox do
    begin
      ActionList := alstMain;
      Name := 'actnFireFox';
      Category := 'Browser';
      Caption := 'FireFox';
      Hint := 'FireFox';
      ImageIndex := 7;
      OnExecute := actnFireFoxExecute;
    end;
    with actnOpera do
    begin
      ActionList := alstMain;
      Name := 'actnOpera';
      Category := 'Browser';
      Caption := 'Opera';
      Hint := 'Opera';
      ImageIndex := 6;
      OnExecute := actnOperaExecute;
    end;
    with actnMozilla do
    begin
      ActionList := alstMain;
      Name := 'actnMozilla';
      Category := 'Browser';
      Caption := 'Mozilla';
      Hint := 'Mozilla';
      ImageIndex := 9;
      OnExecute := actnMozillaExecute;
    end;
    with actnNetscape do
    begin
      ActionList := alstMain;
      Name := 'actnNetscape';
      Category := 'Browser';
      Caption := 'Netscape';
      Hint := 'Netscape';
      ImageIndex := 10;
      OnExecute := actnNetscapeExecute;
    end;
  end;


begin
  InitImageLists;
  InitActionList;
  InitMenus;

  BorderIcons := [biSystemMenu, biMinimize];
  FIconData.cbSize := sizeof(FIconData);
  FIconData.Wnd := Application.Handle;
  FIconData.uID := 100;
  FIconData.uFlags := NIF_MESSAGE + NIF_ICON + NIF_TIP;
  FIconData.uCallbackMessage := WM_USER + 1;
  FIconData.hIcon := Application.Icon.Handle;
  {$IFDEF CLR}
  FIconData.szTip := Application.Title;
  {$ELSE}
  StrPCopy(FIconData.szTip, Application.Title);
  {$ENDIF}
  Application.OnMinimize := MinimizeApp;

  tbarMain := TToolBar.Create(Self);
  butnExecute := TToolButton.Create(Self);
  butnCopyLink := TToolButton.Create(Self);
  butnResetSession := TToolButton.Create(Self);
  ToolButton4 := TToolButton.Create(Self);
  butnDebugLog := TToolButton.Create(Self);
  butnUseSSL := TToolButton.Create(Self);
  ToolButton7 := TToolButton.Create(Self);
  butnHelp := TToolButton.Create(Self);
  cboxSimulator := TComboBox.Create(Self);
  cboxSpeed := TComboBox.Create(Self);
  editParams := TEdit.Create(Self);
  imgDevice := TImage.Create(Self);
  imgSpeed := TImage.Create(Self);
  lablData := TLabel.Create(Self);
  lablSessions := TLabel.Create(Self);
  lablTextDevice := TLabel.Create(Self);
  lablTextParams := TLabel.Create(Self);
  lablTextSent := TLabel.Create(Self);
  lablTextSession := TLabel.Create(Self);
  lablTextSpeed := TLabel.Create(Self);
  memoLog := TMemo.Create(Self);
  pctrlMain := TPageControl.Create(Self);
  tabsLog := TTabSheet.Create(Self);
  tabsServer := TTabSheet.Create(Self);
  with tbarMain do
  begin
    Name := 'tbarMain';
    Parent := Self;
    Left := 0;
    Top := 0;
    Align := alTop;
    AutoSize := True;
    Caption := 'tbarMain';
    Flat := True;
    Images := ilstLarge;
    TabOrder := 0;
    ShowHint := true;
  end;
  with butnHelp do
  begin
    Parent := tbarMain;
    AutoSize := True;
    Hint := 'About IntraWeb';
    OnClick := menuAboutClick;
    ImageIndex := 5;
  end;
  with ToolButton7 do
  begin
    Parent := tbarMain;
    Width := 8;
    Style := tbsSeparator;
  end;
  with butnUseSSL do
  begin
    Parent := tbarMain;
    Action := actnUseSSL;
  end;
  with butnDebugLog do
  begin
    Parent := tbarMain;
    Action := actnDebug;
  end;
  with ToolButton4 do
  begin
    Parent := tbarMain;
    Width := 8;
    Style := tbsSeparator;
  end;
  with butnResetSession do
  begin
    Parent := tbarMain;
    Action := actnResetSessions;
  end;
  with butnCopyLink do
  begin
    Parent := tbarMain;
    Action := actnCopyLink;
  end;
  with butnExecute do
  begin
    Parent := tbarMain;
    Action := actnExecute;
  end;
  with pctrlMain do
  begin
    Name := 'pctrlMain';
    Parent := Self;
    Left := 0;
    Top := 32;
    Width := 419;
    Height := 197;
    ActivePage := tabsLog;
    Align := alClient;
    HotTrack := True;
    MultiLine := True;
//    TabIndex := 1;
    TabOrder := 1;
  end;
  with tabsServer do
  begin
    Name := 'tabsServer';
    Parent := pctrlMain;
    PageControl := pctrlMain;
    BorderWidth := 5;
    Caption := 'Server';
  end;
  with lablTextDevice do
  begin
    Name := 'lablTextDevice';
    Parent := tabsServer;
    Left := 0;
    Top := 40;
    Width := 88;
    Height := 13;
    Caption := 'Device Simulation ';
  end;
  with imgDevice do
  begin
    Name := 'imgDevice';
    Parent := tabsServer;
    Left := 264;
    Top := 27;
    Width := 32;
    Height := 32;
    AutoSize := True;
  end;
  with lablTextSpeed do
  begin
    Name := 'lablTextSpeed';
    Parent := tabsServer;
    Left := 0;
    Top := 84;
    Width := 82;
    Height := 13;
    Caption := 'Speed Simulation';
  end;
  with imgSpeed do
  begin
    Name := 'imgSpeed';
    Parent := tabsServer;
    Left := 264;
    Top := 75;
    AutoSize := True;
  end;
  with lablTextSent do
  begin
    Name := 'lablTextSent';
    Parent := tabsServer;
    Left := 162;
    Top := 7;
    Width := 28;
    Height := 13;
    Caption := RSLogTotalBytes;
  end;
  with lablTextSession do
  begin
    Name := 'lablTextSession';
    Parent := tabsServer;
    Left := 0;
    Top := 7;
    Width := 81;
    Height := 13;
    Caption := 'Active Sessions: ';
  end;
  with lablSessions do
  begin
    Name := 'lablSessions';
    Parent := tabsServer;
    Left := 108;
    Top := 7;
    Width := 6;
    Height := 13;
    Caption := '0';
  end;
  with lablData do
  begin
    Name := 'lablData';
    Parent := tabsServer;
    Left := 198;
    Top := 7;
    Width := 46;
    Height := 13;
    Caption := '0 bytes';
  end;
  with lablTextParams do
  begin
    Name := 'lablTextParams';
    Parent := tabsServer;
    Left := 0;
    Top := 123;
    Width := 94;
    Height := 13;
    Caption := 'Runtime parameters';
  end;
  with cboxSimulator do
  begin
    Name := 'cboxSimulator';
    Parent := tabsServer;
    Left := 108;
    Top := 36;
    Width := 145;
    Height := 21;
    Style := csDropDownList;
    ItemHeight := 13;
    ItemIndex := 0;
    TabOrder := 0;
    Text := 'None';
    OnChange := cboxSimulatorChange;
    Items.Clear;
    Items.Add('None');
    Items.Add('PDA (HTML 3.2)');
    Items.Add('Mobile (WML)');
    Items.Add('Mobile (XHTML MP)');
  end;
  with cboxSpeed do
  begin
    Name := 'cboxSpeed';
    Parent := tabsServer;
    Left := 108;
    Top := 81;
    Width := 145;
    Height := 21;
    Style := csDropDownList;
    ItemHeight := 13;
    ItemIndex := 0;
    TabOrder := 1;
    Text := 'None';
    OnChange := cboxSpeedChange;
    Items.Clear;
    Items.Add('None');
    Items.Add('Dial-up 28.8 kbps');
    Items.Add('Dial-up 33.6 kbps');
    Items.Add('ISDN 64 kbps');
    Items.Add('ISDN 128 kbps');
    Items.Add('DSL/Cabel 384 kbps');
    Items.Add('Ethernet 10 mbps');
    Items.Add('Custom...');
  end;
  with editParams do
  begin
    Name := 'editParams';
    Parent := tabsServer;
    Left := 108;
    Top := 120;
    Width := 208;
    Height := 21;
    TabOrder := 2;
  end;
  with tabsLog do
  begin
    Name := 'tabsLog';
    Parent := pctrlMain;
    PageControl := pctrlMain;
    BorderWidth := 5;
    Caption := 'Log';
    ImageIndex := 1;
  end;
  with memoLog do
  begin
    Name := 'memoLog';
    Parent := tabsLog;
    Left := 0;
    Top := 0;
    Width := 401;
    Height := 159;
    Align := alClient;
    ReadOnly := True;
    ScrollBars := ssVertical;
    TabOrder := 0;
    Clear;
  end;
  with lablTextDevice do
  begin
    Name := 'lablTextDevice';
    Parent := tabsServer;
    Left := 0;
    Top := 40;
    Width := 88;
    Height := 13;
    Caption := 'Device Simulation ';
  end;
  with imgDevice do
  begin
    Name := 'imgDevice';
    Parent := tabsServer;
    Left := 264;
    Top := 27;
    Width := 32;
    Height := 32;
    AutoSize := True;
  end;
  with lablTextSpeed do
  begin
    Name := 'lablTextSpeed';
    Parent := tabsServer;
    Left := 0;
    Top := 84;
    Width := 82;
    Height := 13;
    Caption := 'Speed Simulation';
  end;
  with imgSpeed do
  begin
    Name := 'imgSpeed';
    Parent := tabsServer;
    Left := 264;
    Top := 71;
    Width := 32;
    Height := 32;
    AutoSize := True;
  end;
  with lablTextSent do
  begin
    Name := 'lablTextSent';
    Parent := tabsServer;
    Left := 162;
    Top := 7;
    Width := 28;
    Height := 13;
    Caption := 'Sent: ';
  end;
  with lablTextSession do
  begin
    Name := 'lablTextSession';
    Parent := tabsServer;
    Left := 0;
    Top := 7;
    Width := 81;
    Height := 13;
    Caption := 'Active Sessions: ';
  end;
  with lablTextParams do
  begin
    Name := 'lablTextParams';
    Parent := tabsServer;
    Left := 0;
    Top := 123;
    Height := 13;
    Caption := 'Runtime parameters';
    AutoSize := True;
  end;
  with cboxSimulator do
  begin
    Name := 'cboxSimulator';
    Parent := tabsServer;
    Left := 108;
    Top := 36;
    Width := 145;
    Height := 21;
    Style := csDropDownList;
    ItemHeight := 13;
    ItemIndex := 0;
    TabOrder := 0;
    Text := 'None';
    OnChange := cboxSimulatorChange;
    Items.Clear;
    Items.Add('None');
    Items.Add('PDA (HTML 3.2)');
    Items.Add('Mobile (WML)');
    Items.Add('Mobile (XHTML MP)');
  end;
  with cboxSpeed do
  begin
    Name := 'cboxSpeed';
    Parent := tabsServer;
    Left := 108;
    Top := 81;
    Width := 145;
    Height := 21;
    Style := csDropDownList;
    ItemHeight := 13;
    ItemIndex := 0;
    TabOrder := 1;
    Text := 'None';
    OnChange := cboxSpeedChange;
    Items.Clear;
    Items.Add('None');
    Items.Add('Dial-up 28.8 kbps');
    Items.Add('Dial-up 33.6 kbps');
    Items.Add('ISDN 64 kbps');
    Items.Add('ISDN 128 kbps');
    Items.Add('DSL/Cable 384 kbps');
    Items.Add('Ethernet 10 mbps');
    Items.Add('Custom...');
  end;
  with editParams do
  begin
    Name := 'editParams';
    Parent := tabsServer;
    Left := 108;
    Top := 120;
    Width := 208;
    Height := 21;
    TabOrder := 2;
    OnChange := editParamsChange;
  end;
  with memoLog do
  begin
    Name := 'memoLog';
    Parent := tabsLog;
    Left := 0;
    Top := 0;
    Width := 401;
    Height := 159;
    Align := alClient;
    ReadOnly := True;
    ScrollBars := ssVertical;
    TabOrder := 0;
  end;
  FCustomSpeedLabel := TLabel.Create(Self);
  with FCustomSpeedLabel do
  begin
    Parent := tabsServer;
    Left := 4;
    Top := 163;
    Caption := 'Custom speed (bps)';
    Visible := False;
    ParentFont := true;
  end;

  // Custom speed edit
  FCustomSpeedEdit := TEdit.Create(Self);
  with FCustomSpeedEdit do
  begin
    Parent := tabsServer;
    Text := '0';
    Left := 108;
    Top := 160;
    OnChange := DoOnCustomSpeedChange;
    Visible := False;
    Width := 150;
    ParentFont := true;
  end;

  Self.Menu := menuMain;
  Self.OnClose := FormClose;
  Self.Width := 358; // 417
  Self.Height := 310;

  FStandaloneServer := TIWStandAloneServer.Create(self, OnDebugLog, OnDebugLogBytes, OnUpdateTotalBytes);
  FStandaloneServer.OnNewSession := DoCreateSession;
  FStandaloneServer.OnCloseSession := DoDestroySession;
  if Length(Application.Title) > 0 then
    Caption := Application.Title + ' Server'
  else
    Caption := 'IntraWeb Server';

  actnMozilla.Enabled := FStandaloneServer.TestForMozilla;
  actnIE.Enabled := FStandaloneServer.TestForIE;
  actnFireFox.Enabled := FStandaloneServer.TestForFirefox;
  actnOpera.Enabled := FStandaloneServer.TestForOpera;
  actnNetscape.Enabled := FStandaloneServer.TestForNS6;

  with TINIFile.Create(ChangeFileExt(ParamStr(0), '.iwb')) do
  try
    FStandaloneServer.Params := ReadString('Main', 'Parameters', '');
    FStandaloneServer.DebugLog := ReadBool('Main', 'DebugInfo', false);
    FStandaloneServer.RunSSL := ReadBool('Main', 'SSL', false);
    FStandaloneServer.HTML32 := ReadBool('Main', 'HTML32', false);
    FSTandAloneServer.WML := REadBool('Main', 'WML', False);
    FSTandAloneServer.XHTMLMP := REadBool('Main', 'XHTMLMP', False);
    FStandaloneServer.RunIn := TIWWebBrowser(ReadInteger('Main', 'RunIn', Integer(wbDefault)));
    actnRunTray.Checked := ReadBool('Main', 'RunInTray', true);
    actnRunMinimized.Checked := ReadBool('Main', 'RunMinimized', false);
    FBitsPerSec := ReadInteger('HTTP', 'SpeedLimit', 0);
    SetConnectionSpeed(FBitsPerSec);

    if actnRunTray.Checked then
      CreateTrayIcon;
    if actnRunMinimized.Checked then
    begin
      Self.OnShow := OnFirstShow;
      Application.Minimize;
    end;

    UpdateBrowserSelectionAction;

    cboxSimulator.ItemIndex := 0;
    if FStandaloneServer.HTML32 then
      cboxSimulator.ItemIndex := 1;
    if FStandaloneServer.WML then
      cboxSimulator.ItemIndex := 2;
    if FStandaloneServer.XHTMLMP then
      cboxSimulator.ItemIndex := 3;
    editParams.Text := FStandaloneServer.Params;

    case FBitsPerSec of
            0   : cboxSpeed.ItemIndex := 0;
        28800   : cboxSpeed.ItemIndex := 1;
        33600   : cboxSpeed.ItemIndex := 2;
        64000   : cboxSpeed.ItemIndex := 3;
       128000   : cboxSpeed.ItemIndex := 4;
       384000   : cboxSpeed.ItemIndex := 5;
     10000000   : cboxSpeed.ItemIndex := 6;
    else
    begin
      cboxSpeed.ItemIndex := 7;
      FCustomSpeedEdit.Text := IntToStr(FBitsPerSec);
    end
    end;

    cboxSpeedChange(Self);
    cboxSimulatorChange(Self);
    actnSmallIconsExecute(Self);
    Self.Position := poScreenCenter;

  finally
    Free;
  end;
end;

procedure TFormIWMain.Log(const AMsg: string);
begin
  if AMsg <> '' then
  begin
    memoLog.Lines.Add(AMsg);
  end;
end;

procedure TFormIWMain.LogBytes(const ABytes: Integer);
begin
  if ABytes > 0 then
  begin
    memoLog.Lines.Add(' Bytes: ' + FormatFloat('##,###,##0', ABytes));
  end;
end;

procedure TFormIWMain.MinimizeApp(Sender: TObject);
begin
  if actnRunTray.Checked then
  begin
    ShowWindow(Self.Handle, SW_HIDE);
    ShowWindow(Application.Handle, SW_HIDE);
  end;
end;

procedure TFormIWMain.Restore1Click(Sender: TObject);
begin
  WindowState := wsNormal;
  ShowWindow(Self.Handle, SW_SHOWNORMAL);
  ShowWindow(Application.Handle, SW_SHOWNORMAL);
end;

function TFormIWMain.MessageHook(var Msg: TMessage) : Boolean;
var
  LPoint : TPoint;
begin
  Result := False;
  case Msg.Msg of
    WM_USER + 1:
      begin
        case Msg.lParam of
          WM_RBUTTONDOWN: begin
             GetCursorPos(LPoint);
             popupMain.Popup(LPoint.x, LPoint.y);
          end;
          WM_LBUTTONDBLCLK: begin
             Restore1Click(self);
          end;
        end;
        Result := True;
      end;
  end;
end;

procedure TFormIWMain.OnDebugLog(ASender: TObject; ALog: String);
begin
  Log(ALog);
end;

procedure TFormIWMain.OnDebugLogBytes(ASender: Tobject; ABytes: Integer);
begin
  LogBytes(ABytes);
end;

procedure TFormIWMain.OnUpdateTotalBytes(ASender: TObject;
  const ABytes: Integer);
begin
  SetTotalBytes;
end;

procedure TFormIWMain.SetConnectionSpeed(AValue: Integer);
begin
  GHTTPServer.BitsPerSec := FBitsPerSec;
end;

procedure TFormIWMain.SetTotalBytes;
  function FormatBytes(ABytes: Integer): string;
  var
    LValue: Integer;
    LUnit: string;
  begin
    LValue := ABytes;
    LUnit := ' bytes';
    if ABytes > (1024 * 1024) then begin
      LValue := ABytes div (1024 * 1024);
      LUnit := ' MB';
    end else if ABytes > 1024 then begin
      LValue := ABytes div 1024;
      LUnit := ' KB';
    end;
    Result := FormatFloat('##,###,##0', LValue) + LUnit;
  end;
begin
  lablData.Caption := FormatBytes(FStandaloneServer.TotalBytes);
end;

procedure TFormIWMain.UpdateBrowserSelectionAction;
Var
  LSelected: TAction;
begin
  LSelected := actnBrowserDefault;
  actnBrowserDefault.Checked := false;
  actnIE.Checked := False;
  actnMozilla.Checked := False;
  actnFireFox.Checked := False;
  actnNetscape.Checked := False;
  actnOpera.Checked := False;
  case FStandaloneServer.RunIn of
    wbDefault: LSelected := actnBrowserDefault;
    wbIE: LSelected := actnIE;
    wbNS6: LSelected := actnNetscape;
    wbMozilla: LSelected := actnMozilla;
    wbFirefox: LSelected := actnFireFox;
    wbOpera: LSelected := actnOpera;
  end;
  LSelected.Checked := true;
  actnExecute.ImageIndex := LSelected.ImageIndex;
end;

procedure TFormIWMain.DoOnCustomSpeedChange(Sender: TObject);
begin
  FBitsPerSec := StrToIntDef(FCustomSpeedEdit.Text, 0);
  SetConnectionSpeed(FBitsPerSec);
end;

procedure TFormIWMain.actnExecuteOnExecute(Sender: TObject);
begin
  FStandaloneServer.Run;
end;

procedure TFormIWMain.actnRunTrayExecute(Sender: TObject);
begin
  actnRunTray.Checked := not actnRunTray.Checked;
  if actnRunTray.Checked then
    CreateTrayIcon
  else
    FreeTrayIcon;
end;

procedure TFormIWMain.DoCreateSession(Sender: TObject);
begin
  Inc(FSessionCount);
  lablSessions.Caption := Format('%d', [FSessionCount]);
end;

procedure TFormIWMain.DoDestroySession(Sender: TObject);
begin
  Dec(FSessionCount);
  lablSessions.Caption := Format('%d', [FSessionCount]);
end;

procedure TFormIWMain.CreateTrayIcon;
begin
  Application.HookMainWindow(MessageHook);
  {$IFDEF CLR}
  Shell_NotifyIcon(NIM_ADD, FIconData);
  {$ELSE}
  Shell_NotifyIcon(NIM_ADD, @FIconData);
  {$ENDIF}
end;

procedure TFormIWMain.FreeTrayIcon;
begin
  {$IFDEF CLR}
  Shell_NotifyIcon(NIM_DELETE, FIconData);
  {$ELSE}
  Shell_NotifyIcon(NIM_DELETE, @FIconData);
  {$ENDIF}
  Application.UnhookMainWindow(MessageHook);
end;

procedure TFormIWMain.editParamsChange(Sender: TObject);
begin
  FStandaloneServer.Params := editParams.Text;
end;

procedure TFormIWMain.menuAboutClick(Sender: TObject);
var
  LLabel: TLabel;
  LVerLabel: TLabel;
  LImage: TImage;
  LForm: TForm;
  LStream: TStream;
begin
  LForm := TForm.Create(Application); try
    with LForm do begin
      Position := poScreenCenter;
      {$IFDEF Linux}
      BorderStyle := fbsNone;
      {$ELSE}
      BorderStyle := bsNone;
      {$ENDIF}
      VertScrollBar.Visible := false;
      HorzScrollBar.Visible := false;
      Caption := 'About IntraWeb';
    end;
    LImage := TImage.Create(LForm);
    with LImage do begin
      Parent := LForm;
      Name := 'LImage';
      Left := 0;
      Top := 0;
      AutoSize := True;
      {$IFDEF CLR}
      LImage.Picture.Bitmap.LoadFromResourceName('IW_Splash', 'IWMainAboutSplash', System.Reflection.Assembly.GetExecutingAssembly);
      {$ELSE}
      LStream := TResourceStream.Create(GetModuleHandle(nil), 'IW_SPLASH', RT_RCDATA); try
        // {$IFDEF Linux}
        // LImage.Picture.(LStream);
        // {$ELSE}
        LImage.Picture.Graphic := TJPEGImage.Create;
        LImage.Picture.Graphic.LoadFromStream(LStream);
        // {$ENDIF}
      finally FreeAndNil(LStream); end;
      {$ENDIF}
      Align := alClient;
      OnClick := AboutOnClick;
    end;

    LLabel := TLabel.Create(LForm);
    with LLabel do begin
      Parent := LForm;
      AutoSize := True;
      Name := 'LLabel';
      Left := 105;
      Top := 175;
      Caption := 'Version ' + GVersion;
      Transparent := True;
      OnClick := AboutOnClick;
    end;
    LVerLabel := TLabel.Create(LForm);
    with LVerLabel do begin
      Parent := LForm;
      AutoSize := true;
      Name := 'LVerLable';
      Font.Size := 70;
      Font.Color := $000CC999;
      Font.Style := [fsBold];
      Font.Name := 'Times New Roman';
      Caption := Copy(GVersion, 1, 1);
      OnClick := AboutOnClick;
      Left := 10;
      Top := 160;
      Transparent := True;
    end;
    LForm.Width := LImage.Width;
    LForm.Height := LImage.Height;

    LForm.ShowModal;
  finally FreeAndNil(LForm) end;
end;

procedure TFormIWMain.AboutOnClick(Sender: TObject);
begin
  TForm(TControl(Sender).Owner).ModalResult := mrOk;
end;

procedure TFormIWMain.OnFirstShow(Sender: TObject);
begin
  MinimizeApp(Sender);
  OnShow := nil;
end;




end.
